<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BranchStockProducts extends Model 
{

    protected $table = 'branch_stock_products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product()
    {
        return $this->belongsTo('Product');
    }

    public function size()
    {
        return $this->belongsTo('Size');
    }

    public function color()
    {
        return $this->belongsTo('Color');
    }

}